USE master
GO
--Create the patch database backup folder

DECLARE @Directory        VARCHAR(125)
  
CREATE TABLE #FileExists 
        (IsFile bit, 
         IsDir bit, 
         HasParentDir bit)

SET @Directory = 'H:\AG\PatchBackups\VBECS_2.0.0.6_to_2.1.0.3'
INSERT INTO #FileExists exec master.dbo.xp_fileexist @Directory

IF EXISTS (SELECT * FROM #FileExists WHERE IsDir = 0)
        EXECUTE master.dbo.xp_cmdshell 'mkdir "H:\AG\PatchBackups\VBECS_2.0.0.6_to_2.1.0.3"'
DROP TABLE #FileExists

DECLARE @sql        NVARCHAR(4000);
DECLARE @backuppath                VARCHAR(1000);
DECLARE @backupfile    VARCHAR(1000)

SET @backupfile = '@DBNAME@_'  + CONVERT(VARCHAR, GETDATE(), 112) + '_' + LEFT(REPLACE(CONVERT(VARCHAR, GETDATE(), 108),':',''),4) + '.bak';
SET @backuppath =N'H:\AG\PatchBackups\VBECS_2.0.0.6_to_2.1.0.3\'
SET @sql= 'BACKUP DATABASE [@DBNAME@] TO  DISK =N'''+ @backuppath + @backupfile +'''  WITH NOFORMAT, INIT,  NAME = N''@DBNAME@-Full Database Backup'', SKIP, NOREWIND, NOUNLOAD,  STATS = 10, NO_COMPRESSION,  STATS = 10, CHECKSUM';
EXEC  sp_executesql @sql

SET @backupfile = '@DBNAME@_MIRROR_'  + CONVERT(VARCHAR, GETDATE(), 112) + '_' + LEFT(REPLACE(CONVERT(VARCHAR, GETDATE(), 108),':',''),4) + '.bak';
SET @backuppath =N'H:\AG\PatchBackups\VBECS_2.0.0.6_to_2.1.0.3\'
SET @sql= 'BACKUP DATABASE [@DBNAME@_MIRROR] TO  DISK =N'''+ @backuppath + @backupfile +'''  WITH NOFORMAT, INIT,  NAME = N''@DBNAME@_MIRROR-Full Database Backup'', SKIP, NOREWIND, NOUNLOAD,  STATS = 10, NO_COMPRESSION,  STATS = 10, CHECKSUM';
EXEC  sp_executesql @sql